// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Inthread.pas' rev: 10.00

#ifndef InthreadHPP
#define InthreadHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Inyarn.hpp>	// Pascal unit
#include <Intask.hpp>	// Pascal unit
#include <Inthreadsafe.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Inthread
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EInThreadException;
class PASCALIMPLEMENTATION EInThreadException : public Inexception::EInException 
{
	typedef Inexception::EInException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInThreadException(AnsiString AMsg)/* overload */ : Inexception::EInException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInThreadException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EInException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInThreadException(int Ident)/* overload */ : Inexception::EInException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInThreadException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EInException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInThreadException(const AnsiString Msg, int AHelpContext) : Inexception::EInException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInThreadException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EInException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInThreadException(int Ident, int AHelpContext)/* overload */ : Inexception::EInException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInThreadException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EInException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInThreadException(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInThreadTerminateAndWaitFor;
class PASCALIMPLEMENTATION EInThreadTerminateAndWaitFor : public EInThreadException 
{
	typedef EInThreadException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInThreadTerminateAndWaitFor(AnsiString AMsg)/* overload */ : EInThreadException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInThreadTerminateAndWaitFor(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInThreadException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInThreadTerminateAndWaitFor(int Ident)/* overload */ : EInThreadException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInThreadTerminateAndWaitFor(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInThreadException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInThreadTerminateAndWaitFor(const AnsiString Msg, int AHelpContext) : EInThreadException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInThreadTerminateAndWaitFor(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInThreadException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInThreadTerminateAndWaitFor(int Ident, int AHelpContext)/* overload */ : EInThreadException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInThreadTerminateAndWaitFor(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInThreadException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInThreadTerminateAndWaitFor(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TInThreadStopMode { smTerminate, smSuspend };
#pragma option pop

class DELPHICLASS TInThread;
typedef void __fastcall (__closure *TInExceptionThreadEvent)(TInThread* AThread, Sysutils::Exception* AException);

typedef void __fastcall (__closure *TIdNotifyThreadEvent)(TInThread* AThread);

typedef void __fastcall (__closure *TInSynchronizeThreadEvent)(TInThread* AThread, void * AData);

#pragma option push -b-
enum InThread__3 { itoStopped, itoReqCleanup, itoDataOwner, itoTag };
#pragma option pop

typedef Set<InThread__3, itoStopped, itoTag>  TInThreadOptions;

class PASCALIMPLEMENTATION TInThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
protected:
	System::TObject* FData;
	Inglobal::TIdCriticalSection* FLock;
	bool FLoop;
	AnsiString FName;
	TInThreadStopMode FStopMode;
	TInThreadOptions FOptions;
	AnsiString FTerminatingException;
	TMetaClass* FTerminatingExceptionClass;
	Inyarn::TInYarn* FYarn;
	TInExceptionThreadEvent FOnException;
	TIdNotifyThreadEvent FOnStopped;
	virtual void __fastcall AfterRun(void);
	virtual void __fastcall AfterExecute(void);
	virtual void __fastcall BeforeExecute(void);
	virtual void __fastcall BeforeRun(void);
	virtual void __fastcall Cleanup(void);
	virtual void __fastcall DoException(Sysutils::Exception* AException);
	virtual void __fastcall DoStopped(void);
	virtual void __fastcall Execute(void);
	bool __fastcall GetStopped(void);
	virtual bool __fastcall HandleRunException(Sysutils::Exception* AException);
	virtual void __fastcall Run(void) = 0 ;
	/*         class method */ static void __fastcall WaitAllThreadsTerminated(TMetaClass* vmt, int AMSec = 0xea60);
	
public:
	__fastcall virtual TInThread(bool ACreateSuspended, bool ALoop, AnsiString AName);
	__fastcall virtual ~TInThread(void);
	virtual void __fastcall Start(void);
	virtual void __fastcall Stop(void);
	HIDESBASE void __fastcall Synchronize(Classes::TThreadMethod Method)/* overload */;
	HIDESBASE virtual void __fastcall Terminate(void);
	virtual void __fastcall TerminateAndWaitFor(void);
	__property System::TObject* Data = {read=FData, write=FData};
	__property bool Loop = {read=FLoop, write=FLoop, nodefault};
	__property AnsiString Name = {read=FName, write=FName};
	__property ReturnValue ;
	__property TInThreadStopMode StopMode = {read=FStopMode, write=FStopMode, nodefault};
	__property bool Stopped = {read=GetStopped, nodefault};
	__property Terminated ;
	__property AnsiString TerminatingException = {read=FTerminatingException};
	__property TMetaClass* TerminatingExceptionClass = {read=FTerminatingExceptionClass};
	__property Inyarn::TInYarn* Yarn = {read=FYarn, write=FYarn};
	__property TInExceptionThreadEvent OnException = {read=FOnException, write=FOnException};
	__property TIdNotifyThreadEvent OnStopped = {read=FOnStopped, write=FOnStopped};
	
/* Hoisted overloads: */
	
public:
	inline void __fastcall  Synchronize(TMetaClass* vmt, Classes::TThread* AThread, Classes::TThreadMethod AMethod){ TThread::Synchronize(vmt, AThread, AMethod); }
	
};


class DELPHICLASS TInThreadWithTask;
class PASCALIMPLEMENTATION TInThreadWithTask : public TInThread 
{
	typedef TInThread inherited;
	
protected:
	Intask::TInTask* FTask;
	virtual void __fastcall AfterRun(void);
	virtual void __fastcall BeforeRun(void);
	virtual void __fastcall Run(void);
	
public:
	__fastcall TInThreadWithTask(Intask::TInTask* ATask, AnsiString AName);
	__fastcall virtual ~TInThreadWithTask(void);
	__property Intask::TInTask* Task = {read=FTask, write=FTask};
};


typedef TMetaClass* TInThreadClass;

//-- var, const, procedure ---------------------------------------------------
static const Word IdWaitAllThreadsTerminatedCount = 0xea60;
static const Byte IdWaitAllThreadsTerminatedStep = 0xfa;
extern PACKAGE Inthreadsafe::TInThreadSafeInteger* GThreadCount;

}	/* namespace Inthread */
using namespace Inthread;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Inthread
